#include <iostream>
#include <queue>
#include <vector>
#include <algorithm>

using namespace std;

int const LIM = 1010, INF = 1e9, S = (1 << 0), T = (1 << 1);

struct edge_t {
  int from, to, flow, flow_limit, indx, path;

  edge_t(int from, int to, int flow_limit, int rev) :
      from(from),
      to(to),
      flow(0),
      flow_limit(flow_limit),
      indx(rev),
      path(0) {
  }
};

int n, m, s, t, ptr[LIM], level[LIM], mark[LIM];
bool used[LIM];
queue<int> q;
vector<edge_t> g[LIM];

void make_edge(int u, int v) {
  edge_t a(u, v, 1, g[v].size());
  edge_t b(v, u, 0, g[u].size());
  g[u].push_back(a);
  g[v].push_back(b);
}

void bfs(int u) {
  fill(level, level + n, -1);
  q.push(u);
  level[u] = 0;
  while (!q.empty()) {
    int u = q.front();
    q.pop();
    for (int i = 0; i < (int) g[u].size(); ++i) {
      edge_t e = g[u][i];
      if (level[e.to] != -1 || e.flow_limit - e.flow == 0)
        continue;
      level[e.to] = level[u] + 1;
      q.push(e.to);
    }
  }
}

int dfs(int u, int flow = INF) {
  if (!flow || u == t) {
    return flow;
  }
  for (int &i = ptr[u]; i < (int) g[u].size(); ++i) {
    if (level[g[u][i].to] == -1 || level[g[u][i].to] != level[u] + 1)
      continue;
    int pushed = dfs(g[u][i].to, min(flow, g[u][i].flow_limit - g[u][i].flow));
    if (pushed > 0) {
      g[u][i].flow += pushed;
      g[g[u][i].to][g[u][i].indx].flow -= pushed;
      return pushed;
    }
  }
  return 0;
}

void mark_all(int u) {
  used[u] = true;
  for (int i = 0; i < (int) g[u].size(); ++i) {
    if (g[u][i].flow_limit - g[u][i].flow > 0 && !used[g[u][i].to]) {
      mark_all(g[u][i].to);
    }
    if (g[u][i].flow_limit - g[u][i].flow > 0) {
      mark[u] |= mark[g[u][i].to];
    }
  }
}

void mark_start(int u, int mask) {
  used[u] = true;
  mark[u] |= mask;
  for (int i = 0; i < (int) g[u].size(); ++i) {
    if (g[u][i].flow_limit - g[u][i].flow > 0 && !used[g[u][i].to]) {
      mark_start(g[u][i].to, mask);
    }
  }
}

int main() {
  ios_base::sync_with_stdio(false);
  while (cin >> n >> m >> s >> t) {
    if (n == 0 && m == 0)
      break;
    --s; --t;
    for (int i = 0; i < n; ++i) {
      g[i].clear();
    }
    for (int i = 0; i < m; ++i) {
      int u, v;
      cin >> u >> v;
      --u; --v;
      make_edge(u, v);
    }
    int flow = 0;
    while (true) {
      bfs(s);
      if (level[t] == -1)
        break;
      fill(ptr, ptr + n, 0);
      int pushed = dfs(s);
      while (pushed > 0) {
        flow += pushed;
        pushed = dfs(s);
      }
    }
    fill(used, used + n, false);
    fill(mark, mark + n, 0);
    mark[t] = T;
    used[t] = true;
    for (int i = 0; i < n; ++i) {
      if (!used[i]) {
        mark_all(i);
      }
    }
    fill(used, used + n, false);
    mark_start(s, S);
    int count = 0;
    for (int i = 0; i < n; ++i) {
      for (int j = 0; j < (int) g[i].size(); ++j) {
        if (g[i][j].flow_limit != 0) {
          if ((mark[g[i][j].from] & T) && (mark[g[i][j].to] & S)) {
            ++count;
          }
        }
      }
    }
    if (count == 0) {
      cout << flow << ' ' << 0 << '\n';
    } else {
      cout << flow + 1 << ' ' << count << '\n';
    }
  }
  return 0;
}
